/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.OperatorPanelServiceFunction20Bean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.OperatorPanelServiceFunctionsBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.ccfw.mom.PILparImage;
import com.ibm.hsc.cim.client.pi.PIHSCCECCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.common.exceptions.PIHscBaseException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hsc.websm.sfp.srvutil.OPSFMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class OperatorPanelServiceFunctionsTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JOPSTSKD";
    private static final String TRACE_MASKF = "JOPSTSKF";
    private static final String TRACE_MASKT = "JOPSTSKT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.OperatorPanelServiceFunctions";
    private static final String OPSF_PANEL = "OperatorPanelServiceFunctionsPanel";
    private static final String FUNC20_PANEL = "OperatorPanelServiceFunction20";
    private static final String OPSF_BEAN_NAME = "OPSFBean";
    private static final String FUNC20_BEAN_NAME = "Func20Bean";
    private static final String RESOURCE_BUNDLE = "SFPResourceBundle";
    private static final ClassLogInfo logInfo = new ClassLogInfo(-88, -128, "OperatorPanelServiceFunctionsTasklet");
    private final boolean ALLOW_SYSTEM_FUNCTIONS = true;
    private PICec cec;

    public OperatorPanelServiceFunctionsTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<--> OPSFTasklet()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)("--> OPSFTasklet.logException(" + throwable + ")"));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(logInfo, 16384, new HException(throwable)).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<-- OPSFTasklet.logException()");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"--> OPSFTasklet.service(<TaskletRequest>, <TaskletResponse>)");
        try {
            if (panelTaskletRequest.isInitialRequest()) {
                this.serviceInitialRequest(panelTaskletRequest, panelTaskletResponse);
            } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                this.serviceCloseRequest((String)panelTaskletRequest.getSource(), panelTaskletResponse);
            } else {
                String string = (String)panelTaskletRequest.getData("VOPFType");
                if (string.equals("system")) {
                    this.serviceSystemFunctionRequest(panelTaskletRequest, panelTaskletResponse);
                } else if (string.equals("partition")) {
                    this.servicePartitionFunctionRequest(panelTaskletRequest, panelTaskletResponse);
                } else {
                    panelTaskletResponse.noAction();
                }
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Exception in service(): " + exception));
            TaskletException taskletException = new TaskletException((Throwable)exception);
            new AusMicrocodeLog(logInfo, 16385, taskletException).writeEntry(null);
            throw taskletException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<-- OPSFTasklet.service()");
    }

    private void serviceInitialRequest(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKF, (Object)"> OPSFTasklet.serviceInitialRequest()");
        OperatorPanelServiceFunctionsBean operatorPanelServiceFunctionsBean = new OperatorPanelServiceFunctionsBean();
        operatorPanelServiceFunctionsBean.setBeanName(OPSF_BEAN_NAME);
        operatorPanelServiceFunctionsBean.setSystemFunctionsMenuAvailable(true);
        operatorPanelServiceFunctionsBean.setDescriptionText(RESOURCE_BUNDLE, "OPERATOR_PANEL_SERVICE_FUNCTIONS_HEADER_TEXT");
        this.cec = (PICec)((ServiceUtilitiesTarget)this.getSelectedTargets()[0]).getTargetObject();
        String string = this.cec.getUserDefinedName();
        if (string == null || string.length() == 0) {
            string = this.cec.getName();
        }
        operatorPanelServiceFunctionsBean.setSelectedSystem(string);
        Set set = this.cec.getLparImages(new short[]{129, 130});
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (set != null && set.size() > 0) {
            PILparImage pILparImage = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                pILparImage = (PILparImage)iterator.next();
                arrayList.add(new String[]{pILparImage.getUserDefinedName(), pILparImage.getPartitionNumber(), "OPERATOR_PANEL_SERVICE_FUNCTIONS_OS400"});
            }
        }
        operatorPanelServiceFunctionsBean.setPartitionTable(arrayList);
        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, OPSF_PANEL, (PanelBean)operatorPanelServiceFunctionsBean);
        Trace.trace((String)TRACE_MASKF, (Object)"< OPSFTasklet.serviceInitialRequest()");
    }

    private void serviceCloseRequest(String string, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKF, (Object)("<> OPSFTasklet.serviceCloseRequest(" + string + ", <TaskletResponse>"));
        if (string.equals(OPSF_BEAN_NAME)) {
            panelTaskletResponse.terminate();
        } else {
            panelTaskletResponse.dispose();
        }
    }

    private void serviceSystemFunctionRequest(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKF, (Object)"> OPSFTasklet.serviceSystemFunctionRequest(<TaskletRequest>, <TaskletResponse>)");
        int n = (Integer)panelTaskletRequest.getData("VOPFunction");
        Trace.trace((String)TRACE_MASKD, (Object)("kicking off OPS Function: " + n + " on system: " + this.cec.getName()));
        switch (n) {
            case 20: {
                String string;
                String string2;
                Object object;
                String string3 = "";
                try {
                    object = PIHSCCECCIMClient.createInstance(InetAddress.getLocalHost().getHostName(), this.cec.getName(), true, "root/ibmhscS1_0");
                    string2 = object.getProcessorFeatureCode();
                    PICECDataBean pICECDataBean = object.getCECDataBean(new String[]{"power_on_attr", "power_on_type", "power_on_method", "sp_boot_attr", "sp_boot_major_type", "sp_boot_minor_type"});
                    string = this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrCecIplAttributes().intValue()), 4, "0") + this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrCecIplMajorType().intValue()), 2, "0") + this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrCecIplMinorType().intValue()), 2, "0");
                    string3 = this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrFspBootAttributes().intValue()), 4, "0") + this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrFspBootMajorType().intValue()), 2, "0") + this.leftPad(Integer.toHexString(pICECDataBean.getPlatformCurrFspBootMinorType().intValue()), 2, "0");
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("Exception in serviceSystemFunctionRequest(): " + exception));
                    new AusMicrocodeLog(logInfo, 16387, new HException((Throwable)exception)).writeEntry(null);
                    this.showErrorMessageBox("OPERATOR_PANEL_SERVICE_FUNCTIONS_ERROR", new String[]{String.valueOf(n)});
                    panelTaskletResponse.noAction();
                    return;
                }
                object = new OperatorPanelServiceFunction20Bean();
                object.setBeanName(FUNC20_BEAN_NAME);
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setSystemName(this.cec.getUserDefinedName());
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setSystemModel(this.cec.getModel());
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setSystemMachineType(this.cec.getMachineType());
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setProcessorFeatureCode(string2);
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setCECIPLType(string);
                ((OperatorPanelServiceFunction20Bean)((Object)object)).setFSPIPLType(string3);
                panelTaskletResponse.openModalChild(AUIML_FILE_NAME, FUNC20_PANEL, (PanelBean)object);
                break;
            }
            default: {
                panelTaskletResponse.noAction();
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)"< OPSFTasklet.serviceSystemFunctionRequest()");
    }

    private String leftPad(String string, int n, String string2) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n2++ < n) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void servicePartitionFunctionRequest(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKF, (Object)"> OPSFTasklet.servicePartitionFunctionRequest(<TaskletRequest>, <TaskletResponse>)");
        int n = (Integer)panelTaskletRequest.getData("VOPFunction");
        String string = (String)panelTaskletRequest.getData("LparNum");
        Trace.trace((String)TRACE_MASKD, (Object)("kicking off OPS Function: " + n + " on partition number: " + string));
        PIHSCLPARClient pIHSCLPARClient = null;
        try {
            PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(InetAddress.getLocalHost().getHostName(), null);
            String string2 = this.cec.getName();
            pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(string2, string, true);
            if (pIHSCLPARClient == null) {
                throw new PIHscBaseException("7003");
            }
        }
        catch (Throwable throwable) {
            this.showErrorMessageBox("OPERATOR_PANEL_SERVICE_FUNCTIONS_PARTION_REMOVED", null);
            panelTaskletResponse.update((Object)string);
            Trace.trace((String)TRACE_MASKF, (Object)"< OPSFTasklet.servicePartitionFunctionRequest() EARLY EXIT: partition unavailable");
            return;
        }
        try {
            switch (n) {
                case 21: {
                    pIHSCLPARClient.forceDST();
                    break;
                }
                case 65: {
                    pIHSCLPARClient.enableDST("0");
                    break;
                }
                case 66: {
                    pIHSCLPARClient.enableDST("1");
                    break;
                }
                case 67: {
                    pIHSCLPARClient.diskIOP("0");
                    break;
                }
                case 68: {
                    pIHSCLPARClient.diskIOP("1");
                    break;
                }
                case 69: {
                    pIHSCLPARClient.diskIOP("2");
                    break;
                }
                case 70: {
                    pIHSCLPARClient.dumpToLoad("1");
                }
            }
            this.showInfoMessageBox("OPERATOR_PANEL_SERVICE_FUNCTIONS_FUNCTION_INIT", new String[]{String.valueOf(n)});
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("Exception in servicePartitionFunctionRequest(): " + exception));
            new AusMicrocodeLog(logInfo, 16386, new HException((Throwable)exception)).writeEntry(null);
            this.showErrorMessageBox("OPERATOR_PANEL_SERVICE_FUNCTIONS_ERROR", new String[]{String.valueOf(n)});
        }
        panelTaskletResponse.noAction();
        Trace.trace((String)TRACE_MASKF, (Object)"< OPSFTasklet.servicePartitionFunctionRequest()");
    }

    private void showErrorMessageBox(String string, String[] stringArray) throws TaskletException {
        this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "OPERATOR_PANEL_SERVICE_FUNCTIONS_ERRORMSG_TITLE"), new OPSFMessageText(RESOURCE_BUNDLE, string, stringArray, MsgType.ERROR_MESSAGE), MsgType.ERROR_MESSAGE, null);
    }

    private void showInfoMessageBox(String string, String[] stringArray) throws TaskletException {
        this.showMessageBox(true, new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "OPERATOR_PANEL_SERVICE_FUNCTIONS"), new OPSFMessageText(RESOURCE_BUNDLE, string, stringArray, MsgType.INFORMATION_MESSAGE), MsgType.INFORMATION_MESSAGE, null);
    }
}

